/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.gui.TableConstraints;
import acm.util.ErrorException;
import acm.util.OptionTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.JSlider;

public class TableLayout
implements LayoutManager2 {
    public static final int NONE = 0;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int BOTH = 1;
    public static final int CENTER = 10;
    public static final int LEFT = 11;
    public static final int RIGHT = 12;
    public static final int TOP = 13;
    public static final int BOTTOM = 14;
    public static final int FILL = 1;
    private static final int LAYOUT_CONTAINER_MODE = 0;
    private static final int MINIMUM_LAYOUT_SIZE_MODE = 1;
    private static final int PREFERRED_LAYOUT_SIZE_MODE = 2;
    private static final int MINIMUM_SCROLLBAR_SIZE = 100;
    private Container targetContainer;
    private HashMap<Component, GridBagConstraints> constraintTable;
    private HashMap<Component, TableConstraints> layoutTable;
    private HashMap<String, Object> propertyTable;
    private boolean useStrictGridBagModel;
    private int nRows;
    private int nColumns;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int defaultFill;
    private int hGap;
    private int vGap;

    public TableLayout() {
        this(0, 0);
    }

    public TableLayout(int rows, int columns) {
        this(rows, columns, 0, 0);
    }

    public TableLayout(int rows, int columns, int hgap, int vgap) {
        this.nRows = rows;
        this.nColumns = columns;
        this.hGap = hgap;
        this.vGap = vgap;
        this.horizontalAlignment = 10;
        this.verticalAlignment = 10;
        this.defaultFill = 1;
        this.constraintTable = new HashMap();
        this.propertyTable = new HashMap();
        this.layoutTable = null;
    }

    public void setColumnCount(int columns) {
        this.nColumns = columns;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public void setRowCount(int rows) {
        this.nRows = rows;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getRowCount() {
        return this.nRows;
    }

    public void setHorizontalAlignment(int align) {
        this.horizontalAlignment = align;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int align) {
        this.verticalAlignment = align;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setDefaultFill(int fill) {
        this.defaultFill = fill;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getDefaultFill() {
        return this.defaultFill;
    }

    public void setHgap(int pixels) {
        this.hGap = pixels;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHgap() {
        return this.hGap;
    }

    public void setVgap(int pixels) {
        this.vGap = pixels;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVgap() {
        return this.vGap;
    }

    public void setStrictGridBagModel(boolean flag) {
        this.useStrictGridBagModel = flag;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public boolean isStrictGridBagModel() {
        return this.useStrictGridBagModel;
    }

    public void setConstraints(Component comp, GridBagConstraints constraints) {
        this.constraintTable.put(comp, (GridBagConstraints)constraints.clone());
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public void setConstraints(Component comp, String constraints) {
        this.setConstraints(comp, new TableConstraints(constraints));
    }

    public TableConstraints getConstraints(Component comp) {
        GridBagConstraints gbc = this.lookupConstraints(comp);
        return gbc == null ? null : new TableConstraints(gbc);
    }

    public void addLayoutComponent(String constraints, Component comp) {
        this.addLayoutComponent(comp, constraints);
    }

    public void removeLayoutComponent(Component comp) {
        this.constraintTable.remove(comp);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public Dimension preferredLayoutSize(Container target) {
        if (target.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(target, 2);
    }

    public Dimension minimumLayoutSize(Container target) {
        if (target.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(target, 1);
    }

    public void layoutContainer(Container target) {
        this.targetContainer = target;
        this.processLayout(target, 0);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            constraints = new TableConstraints("");
            ((TableConstraints)constraints).fill = this.defaultFill;
        } else if (constraints instanceof String) {
            OptionTable options = new OptionTable(((String)constraints).toLowerCase(), TableConstraints.LEGAL_KEYS);
            constraints = new TableConstraints(options.getMap());
            if (!options.isSpecified("fill")) {
                ((TableConstraints)constraints).fill = options.isSpecified("anchor") ? 0 : this.defaultFill;
            }
        } else if (!(constraints instanceof GridBagConstraints)) {
            throw new ErrorException("TableLayout: Illegal constraints");
        }
        this.constraintTable.put(comp, (GridBagConstraints)constraints);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public synchronized void invalidateLayout(Container target) {
        this.layoutTable = null;
    }

    public String toString() {
        String str = this.getClass().getName();
        str = String.valueOf(str) + "[rows=" + this.nRows + ",columns=" + this.nColumns;
        if (this.hGap != 0) {
            str = String.valueOf(str) + ",hgap=" + this.hGap;
        }
        if (this.vGap != 0) {
            str = String.valueOf(str) + ",vgap=" + this.vGap;
        }
        str = String.valueOf(str) + "]";
        return str;
    }

    protected GridBagConstraints lookupConstraints(Component comp) {
        return this.constraintTable.get(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableConstraints lookupConstraints(Component comp, Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (this.layoutTable == null) {
                this.computeLayoutTable(target);
            }
            return this.layoutTable.get(comp);
        }
    }

    private Dimension getMinimumComponentSize(Component comp) {
        if (this.isScrollbar(comp)) {
            return this.getMinimumScrollbarSize(comp);
        }
        return comp.getMinimumSize();
    }

    private Dimension getPreferredComponentSize(Component comp) {
        if (this.isScrollbar(comp)) {
            return this.getMinimumScrollbarSize(comp);
        }
        return comp.getPreferredSize();
    }

    private boolean isScrollbar(Component comp) {
        return comp instanceof Scrollbar || comp instanceof JScrollBar || comp instanceof JSlider;
    }

    private Dimension getMinimumScrollbarSize(Component comp) {
        Dimension size = comp.getMinimumSize();
        try {
            Class<?> scrollbarClass = comp.getClass();
            Method getOrientation = scrollbarClass.getMethod("getOrientation", new Class[0]);
            int orientation = (Integer)getOrientation.invoke((Object)comp, new Object[0]);
            if (orientation == 0) {
                size.width = Math.max(size.width, 100);
            } else {
                size.height = Math.max(size.height, 100);
            }
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension processLayout(Container target, int caller) {
        Object object = target.getTreeLock();
        synchronized (object) {
            return this.lockedProcessLayout(target, caller);
        }
    }

    private synchronized Dimension lockedProcessLayout(Container target, int caller) {
        Dimension result = null;
        if (this.layoutTable == null) {
            this.computeLayoutTable(target);
        }
        int nr = this.getIntProperty("nRows");
        int nc = this.getIntProperty("nColumns");
        int[] heights = new int[nr];
        int[] widths = new int[nc];
        int nComponents = target.getComponentCount();
        int i = 0;
        while (i < nComponents) {
            Component comp = target.getComponent(i);
            TableConstraints tc = this.layoutTable.get(comp);
            int column = tc.gridx;
            int row = tc.gridy;
            int width = this.getIntProperty("width" + column);
            int height = this.getIntProperty("height" + row);
            if (width == 0) {
                width = caller == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)comp).width : this.getPreferredComponentSize((Component)comp).width;
                width += 2 * tc.ipadx + tc.insets.left + tc.insets.right;
            }
            if (height == 0) {
                height = caller == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)comp).height : this.getPreferredComponentSize((Component)comp).height;
                height += 2 * tc.ipady + tc.insets.top + tc.insets.bottom;
            }
            if (tc.gridwidth <= 1) {
                widths[column] = Math.max(widths[column], width);
            }
            if (tc.gridheight <= 1) {
                heights[row] = Math.max(heights[row], height);
            }
            ++i;
        }
        int width = this.hGap;
        int height = this.vGap;
        double[] weightX = new double[nc];
        double[] weightY = new double[nr];
        double totalX = 0.0;
        double totalY = 0.0;
        int column = 0;
        while (column < nc) {
            width += widths[column] + this.hGap;
            weightX[column] = this.getDoubleProperty("weightx" + column);
            totalX += weightX[column];
            ++column;
        }
        int row = 0;
        while (row < nr) {
            height += heights[row] + this.vGap;
            weightY[row] = this.getDoubleProperty("weighty" + row);
            totalY += weightY[row];
            ++row;
        }
        if (caller == 0) {
            Dimension size = target.getSize();
            Insets insets = target.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            int extraX = size.width - width;
            int extraY = size.height - height;
            int startX = insets.left;
            int startY = insets.top;
            if (totalX == 0.0) {
                switch (this.horizontalAlignment) {
                    case 11: {
                        extraX = 0;
                        break;
                    }
                    case 10: {
                        startX += extraX / 2;
                        extraX = 0;
                        break;
                    }
                    case 12: {
                        startX += extraX;
                        extraX = 0;
                        break;
                    }
                    case 1: {
                        totalX = nc;
                        int column2 = 0;
                        while (column2 < nc) {
                            weightX[column2] = 1.0;
                            ++column2;
                        }
                        break;
                    }
                }
            }
            if (totalY == 0.0) {
                switch (this.verticalAlignment) {
                    case 13: {
                        extraY = 0;
                        break;
                    }
                    case 10: {
                        startY += extraY / 2;
                        extraY = 0;
                        break;
                    }
                    case 14: {
                        startY += extraY;
                        extraY = 0;
                        break;
                    }
                    case 1: {
                        totalY = nr;
                        int row2 = 0;
                        while (row2 < nr) {
                            weightY[row2] = 1.0;
                            ++row2;
                        }
                        break;
                    }
                }
            }
            int[] xc = new int[nc];
            int x = this.hGap + startX;
            int column3 = 0;
            while (column3 < nc) {
                xc[column3] = x;
                if (extraX > 0) {
                    int pad = (int)Math.round((double)extraX * weightX[column3] / totalX);
                    int n = column3;
                    widths[n] = widths[n] + pad;
                    extraX -= pad;
                    totalX -= weightX[column3];
                }
                x += widths[column3] + this.hGap;
                ++column3;
            }
            int[] yc = new int[nr];
            int y = this.vGap + startY;
            int row3 = 0;
            while (row3 < nr) {
                yc[row3] = y;
                if (extraY > 0) {
                    int pad = (int)Math.round((double)extraY * weightY[row3] / totalY);
                    int n = row3;
                    heights[n] = heights[n] + pad;
                    extraY -= pad;
                    totalY -= weightY[row3];
                }
                y += heights[row3] + this.vGap;
                ++row3;
            }
            int i2 = 0;
            while (i2 < nComponents) {
                Component comp = target.getComponent(i2);
                TableConstraints tc = this.layoutTable.get(comp);
                int column4 = tc.gridx;
                int row4 = tc.gridy;
                int bx = xc[column4] + tc.insets.left;
                int by = yc[row4] + tc.insets.top;
                int bw = widths[column4];
                int ix = 1;
                while (ix < tc.gridwidth && column4 + ix < nc) {
                    bw += widths[column4 + ix] + this.hGap;
                    ++ix;
                }
                bw -= tc.insets.left + tc.insets.right;
                int bh = heights[row4];
                int iy = 1;
                while (iy < tc.gridheight && row4 + iy < nr) {
                    bh += heights[row4 + iy] + this.vGap;
                    ++iy;
                }
                Dimension pSize = this.useStrictGridBagModel ? this.getMinimumComponentSize(comp) : this.getPreferredComponentSize(comp);
                Rectangle bounds = this.computeCellBounds(new Rectangle(bx, by, bw, bh -= tc.insets.top + tc.insets.bottom), pSize, tc);
                comp.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                ++i2;
            }
        } else {
            result = new Dimension(width, height);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void computeLayoutTable(Container target) {
        unfinishedSpans = null;
        row = 0;
        column = 0;
        layoutColumns = this.nColumns;
        nComponents = target.getComponentCount();
        nextEndRow = false;
        this.layoutTable = new HashMap<K, V>();
        i = 0;
        while (i < nComponents) {
            comp = target.getComponent(i);
            tc = this.getConstraints(comp);
            if (tc.gridx != -1) {
                column = tc.gridx;
            }
            if (tc.gridy != -1) {
                row = tc.gridy;
            }
            if (this.nRows <= 0 || row < this.nRows) ** GOTO lbl28
            throw new ErrorException("TableLayout: Too many rows specified");
lbl-1000:
            // 1 sources

            {
                if (layoutColumns <= 0 || ++column < layoutColumns) continue;
                c = 0;
                while (c < unfinishedSpans.length) {
                    if (unfinishedSpans[c] > 0) {
                        v0 = c;
                        unfinishedSpans[v0] = unfinishedSpans[v0] - 1;
                    }
                    ++c;
                }
                ++row;
                column = this.getFirstAvailableColumn(unfinishedSpans);
lbl28:
                // 3 sources

                ** while (unfinishedSpans != null && column < unfinishedSpans.length && unfinishedSpans[column] > 0)
            }
lbl29:
            // 1 sources

            tc.gridx = column;
            tc.gridy = row;
            endrow = nextEndRow;
            this.setMaxProperty("width" + column, tc.width);
            this.setMaxProperty("height" + row, tc.height);
            this.setMaxProperty("weightx" + column, tc.weightx);
            this.setMaxProperty("weighty" + row, tc.weighty);
            colspan = 1;
            switch (tc.gridwidth) {
                case 0: {
                    endrow = true;
                    if (layoutColumns <= 0) break;
                    colspan = layoutColumns - column;
                    break;
                }
                case -1: {
                    if (layoutColumns <= 0) {
                        throw new ErrorException("TableLayout: Illegal to use gridwidth=RELATIVE in first row");
                    }
                    colspan = layoutColumns - column - 1;
                    nextEndRow = true;
                    break;
                }
                default: {
                    colspan = tc.gridwidth;
                    v1 = endrow = this.nColumns > 0 && column + tc.gridwidth >= this.nColumns;
                }
            }
            if (colspan > 1 && unfinishedSpans != null) {
                c = column;
                while (c < Math.min(unfinishedSpans.length, column + colspan)) {
                    if (unfinishedSpans[c] != 0) {
                        throw new ErrorException("TableLayout: Overlapping cells");
                    }
                    ++c;
                }
            }
            rowspan = 1;
            switch (tc.gridheight) {
                case 0: {
                    rowspan = 0x7FFFFFFF;
                    break;
                }
                case -1: {
                    throw new ErrorException("TableLayout: Illegal to use gridheight=RELATIVE");
                }
                default: {
                    rowspan = tc.gridheight;
                }
            }
            if (rowspan > 1) {
                if (unfinishedSpans == null) {
                    unfinishedSpans = new int[column + colspan];
                } else if (unfinishedSpans.length < column + colspan) {
                    oldSpans = unfinishedSpans;
                    unfinishedSpans = new int[column + colspan];
                    System.arraycopy(oldSpans, 0, unfinishedSpans, 0, oldSpans.length);
                }
                c = column;
                while (c < column + colspan) {
                    unfinishedSpans[c] = rowspan;
                    ++c;
                }
            }
            tc.gridwidth = colspan;
            tc.gridheight = rowspan;
            this.layoutTable.put(comp, tc);
            column += colspan;
            while (endrow || layoutColumns > 0 && column >= layoutColumns) {
                if (layoutColumns <= 0) {
                    layoutColumns = column;
                }
                if (unfinishedSpans != null) {
                    c = 0;
                    while (c < unfinishedSpans.length) {
                        if (unfinishedSpans[c] > 0) {
                            v2 = c;
                            unfinishedSpans[v2] = unfinishedSpans[v2] - 1;
                        }
                        ++c;
                    }
                }
                ++row;
                column = this.getFirstAvailableColumn(unfinishedSpans);
                endrow = false;
            }
            ++i;
        }
        if (layoutColumns <= 0) {
            layoutColumns = column;
        }
        this.setIntProperty("nColumns", layoutColumns);
        this.setIntProperty("nRows", row + 1);
    }

    private Rectangle computeCellBounds(Rectangle enclosure, Dimension psize, TableConstraints tc) {
        int x = enclosure.x;
        int y = enclosure.y;
        int width = enclosure.width;
        int height = enclosure.height;
        if (tc.fill == 0 || tc.fill == 3) {
            width = psize.width;
        }
        if (tc.fill == 0 || tc.fill == 2) {
            height = psize.height;
        }
        if (width != enclosure.width) {
            switch (tc.anchor) {
                case 10: 
                case 11: 
                case 15: {
                    x += (enclosure.width - width) / 2;
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    x += enclosure.width - width;
                }
            }
        }
        if (height != enclosure.height) {
            switch (tc.anchor) {
                case 10: 
                case 13: 
                case 17: {
                    y += (enclosure.height - height) / 2;
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    y += enclosure.height - height;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    private void setMaxProperty(String key, int value) {
        this.setIntProperty(key, Math.max(value, this.getIntProperty(key)));
    }

    private void setMaxProperty(String key, double value) {
        this.setDoubleProperty(key, Math.max(value, this.getDoubleProperty(key)));
    }

    private void setIntProperty(String key, int value) {
        this.propertyTable.put(key, new Integer(value));
    }

    private int getIntProperty(String key) {
        Object binding = this.propertyTable.get(key);
        if (binding == null) {
            return 0;
        }
        return (Integer)binding;
    }

    private void setDoubleProperty(String key, double value) {
        this.propertyTable.put(key, new Double(value));
    }

    private double getDoubleProperty(String key) {
        Object binding = this.propertyTable.get(key);
        if (binding == null) {
            return 0.0;
        }
        return (Double)binding;
    }

    private int getFirstAvailableColumn(int[] unfinishedSpans) {
        if (this.useStrictGridBagModel && unfinishedSpans != null) {
            int column = unfinishedSpans.length;
            while (column > 0) {
                if (unfinishedSpans[column - 1] > 0) {
                    return column;
                }
                --column;
            }
        }
        return 0;
    }
}

